//
//  MCMailEngine.h
//  MCMailEngine
//
//  Created by Andreas Monitzer on 2004-09-08.
//  Copyright 2004 Freshly Squeezed Software. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MCMailEngine : NSObject {
	NSString	*hostname;
	UInt16		port;
	BOOL		useTLS;
	
	NSString	*username;
	NSString	*password;
	BOOL		usePassword;
	
	NSException *currentException;
}

+ (MCMailEngine*)sharedInstance;

- (NSString *)hostname;
- (void)setHostname:(NSString *)aString;

- (UInt16)port;
- (void)setPort:(UInt16)aPort;

- (BOOL)useTLS;
- (void)setUseTLS:(BOOL)aBool;

- (NSString *)username;
- (void)setUsername:(NSString *)aName;

- (NSString *)password;
- (void)setPassword:(NSString *)aPassword;

- (BOOL)usePassword;
- (void)setUsePassword:(BOOL)aBool;

- (BOOL)sendMailTo:(NSString *)aToAddress from:(NSString *)aFromAddress 
		   subject:(NSString *)aSubject body:(NSString *)aBody 
	attachmentPath:(NSString *)anAttachmentPath attachmentName:(NSString *)aFilename;

- (NSException *)currentException;
// returns nil if no exception on last send.

@end
